CREATE OR REPLACE FUNCTION addindex() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF exists (SELECT 1 from pg_indexes WHERE tablename= 'pdv_comprovantes_armazenados' and INDEXNAME='pdv_comprovantes_armazenados_pkey') THEN 
		ALTER TABLE pdv_comprovantes_armazenados DROP CONSTRAINT pdv_comprovantes_armazenados_pkey;
    END IF;
	
	IF exists (SELECT 1 from pg_indexes WHERE tablename= 'pdv_comprovantes_armazenados' and INDEXNAME='pk_pdv_comprovantes_armazenados') THEN 
		ALTER TABLE pdv_comprovantes_armazenados DROP CONSTRAINT pk_pdv_comprovantes_armazenados;
    END IF;
	
	IF exists (SELECT 1 FROM information_schema.sequences WHERE  sequence_name = 'pdv_comprovantes_armazenados_pkey') THEN 
	 DROP SEQUENCE pdv_comprovantes_armazenados_pkey;
	END IF; 

	if not exists (select 1 from information_schema.columns where table_name ilike 'pdv_comprovantes_armazenados' and column_name ilike 'id_comprovantes') then
		ALTER TABLE pdv_comprovantes_armazenados ADD COLUMN id_comprovantes SERIAL PRIMARY KEY;
    END IF;
	raise notice 'operacao realizada com sucesso.';
	
END;
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addindex() OWNER TO postgres; 
SELECT addindex(); 
DROP FUNCTION addindex();